<?php // checkin.php ?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Sunny-Side Gym – Check-In</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="icon" href="../admin/includes/logo.png" type="image/png">

  <style>
    body {
      font-family: 'Segoe UI', sans-serif;
      background-color: #fac13a;
      transition: background-color 0.5s ease;
      height: 100vh;
      margin: 0;
      display: flex;
      flex-direction: column;
      align-items: center;
      justify-content: center;
    }

    .status-ok    { background-color: #28a745 !important; color: #fff; }
    .status-due   { background-color: #FFF3CD !important; }
    .status-expired { background-color: #dc3545 !important; color: #fff; }

    .logo {
      max-width: 260px;
      margin-bottom: 30px;
    }

    .overlay-box {
      background: rgba(255, 255, 255, 0.95);
      border-radius: 16px;
      padding: 30px;
      box-shadow: 0 0 30px rgba(0,0,0,0.25);
      max-width: 600px;
      width: 95%;
      text-align: center;
    }

    #nfcInput {
      font-size: 28px;
      padding: 16px;
      margin-bottom: 25px;
    }

    /* Pop-up */
    .popup {
      position: fixed;
      top: 50%;
      left: 50%;
      transform: translate(-50%, -50%);
      z-index: 9999;
      background: #fff;
      border-radius: 16px;
      padding: 30px;
      box-shadow: 0 0 30px rgba(0,0,0,0.35);
      max-width: 840px;
      width: 95%;
      display: none;
    }

    .popup.show {
      display: block;
    }

    .result-wrapper {
      display: flex;
      align-items: center;
      gap: 25px;
      text-align: left;
    }

    .photo {
      width: 280px;
      height: 280px;
      border-radius: 12px;
      object-fit: cover;
      border: 4px solid #333;
    }

    .info-box h3 {
      font-size: 2rem;
      font-weight: bold;
      margin-bottom: 10px;
    }

    .info-box p {
      font-size: 1.3rem;
      margin: 0;
    }

   #message {
    font-size: 1.3rem;
    font-weight: bold;
    margin-top: 10px;
    color: red;
}
.info-box {
    color: #000;
 }.info-box p{
     font-size: 30px !important;
}
.alert-staff {
  position: fixed;
  top: 50%;
  left: 50%;
  transform: translate(-50%, -50%);
  z-index: 9999;
  background: #fff;
  border-radius: 16px;
  padding: 30px;
  box-shadow: 0 0 30px rgba(0, 0, 0, 0.35);
  max-width: 700px;
  width: 90%;
  display: none;
  text-align: left;
}
.alert-staff-content {
  display: flex;
  align-items: center;
  gap: 25px;
}

.alert-staff-photo {
  width: 240px;
  height: 240px;
  object-fit: cover;
  border-radius: 12px;
  border: 4px solid #dc3545;
}

.alert-staff-text {
  font-size: 1.6rem;
  color: #dc3545;
  font-weight: bold;
  line-height: 1.4;
}

    @media (max-width: 768px) {
      .result-wrapper {
        flex-direction: column;
        text-align: center;
      }
      .photo {
        margin-bottom: 15px;
      }
    }
  </style>
</head>
<body class="default-bg text-center">

  <img src="../admin/includes/logo.png" class="logo" alt="Sunnyside Gym Logo">

  <div class="overlay-box">
    <h2>Self Check-In</h2>
    <input type="text" id="nfcInput" class="form-control" placeholder="Tap your card..." autofocus autocomplete="off">
  </div>

  <!-- Popup Result -->
  <div id="resultPopup" class="popup">
    <div class="result-wrapper">
      <img id="photo" src="../admin/uploads/default.png" alt="Photo" class="photo">
      <div class="info-box">
        <h3 id="name">Name</h3>
        <p><strong>Status:</strong> <span id="status"></span></p>
        <p><strong>Expiry:</strong> <span id="expiry"></span></p>
        <p id="message"></p>
      </div>
    </div>
  </div>

 <div id="expiredAlert" class="alert-staff">
  <div class="alert-staff-content">
    <img src="../admin/uploads/default.png" alt="Expired Photo" class="alert-staff-photo">
    <div class="alert-staff-text">
      Your membership has expired.<br>Please seek a member of staff.
    </div>
  </div>
</div>


<script>
  const input = document.getElementById('nfcInput');
  const popup = document.getElementById('resultPopup');
  const name = document.getElementById('name');
  const status = document.getElementById('status');
  const expiry = document.getElementById('expiry');
  const message = document.getElementById('message');
  const photo = document.getElementById('photo');
  const expiredAlert = document.getElementById('expiredAlert');
  const body = document.body;

  let isScanning = false;
  let timeout;
  let scanDelay;

  input.addEventListener('input', () => {
    clearTimeout(scanDelay); // cancel any existing input delay

    const uid = input.value.trim();
    if (uid.length >= 10) {
      scanDelay = setTimeout(() => {
        if (isScanning) return;
        isScanning = true;

        fetch('../admin/scan_process.php', {
          method: 'POST',
          headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
          body: 'uid=' + encodeURIComponent(uid)
        })
        .then(res => res.json())
        .then(data => {
          clearTimeout(timeout);
          popup.classList.remove('show');
          expiredAlert.style.display = 'none';
          body.classList.remove('status-ok', 'status-due', 'status-expired', 'default-bg');

          const statusText = (data.status || '').toLowerCase();

          if (statusText === 'expired') {
            body.classList.add('status-expired');
            expiredAlert.style.display = 'block';
          } else {
            name.textContent = data.name || '';
            status.textContent = data.status || '';
            expiry.textContent = data.expiry || '';
            message.textContent = data.message || '';

            const photoFile = (data.photo && data.photo !== 'default.png') ? data.photo : 'default.png';
            photo.src = '../admin/uploads/' + photoFile;

            if (statusText === 'ok') {
              body.classList.add('status-ok');
            } else if (statusText === 'due') {
              body.classList.add('status-due');
            } else {
              body.classList.add('default-bg');
            }

            popup.classList.add('show');
          }

          input.value = '';

          timeout = setTimeout(() => {
            popup.classList.remove('show');
            expiredAlert.style.display = 'none';
            body.className = 'default-bg text-center';
          }, 7000);

          isScanning = false;
        });
      }, 500); // 500ms delay before making fetch request
    }
  });
</script>


  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
